﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>Zmiana parametrów zasobu</title>
        <script runat="server">

    ParametryWydrukuDokumentu parametry;
    [Context]
    public ParametryWydrukuDokumentu Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;

        // TASK: 2526. [4.3]
        /***
         * TASK: 5221. [7.3] /sbm
         * 
         * dc.AdditionalFooterInfo = true;
         */
        dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;
        
        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;
        SectionMagazynDo.Visible = dokument.MagazynDo!=null;
    
        //Formatujemy informację o podmiocie
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            if (dokument.Wydruk.JestOdbiorca)
                kto2.EditValue = "Kontrahent";
            else
                kto2.EditValue = dokument.Definicja.DostawcaOdbiorca;
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
    
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        string title = dokument.Definicja.TytulWydruku;
        if (title!="")
            title += " ";
        title += dokument.Numer;
        if (dokument.Wydruk.OpisStanu!="")
            title += "|" + dokument.Wydruk.OpisStanu;        
        title += "|</STRONG>Data i miejsce wystawienia:<STRONG> " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);
        title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;
        if (kopia.Kopia==TypKopiiDokumentu.Duplikat || kopia.Kopia==TypKopiiDokumentu.OryginałDuplikat || kopia.Kopia==TypKopiiDokumentu.KopiaDuplikat )
            title += "|</STRONG>Data wystawienia duplikatu:<STRONG> " + Date.Today;
        
        ReportHeader1.Title = title;
    }
    
        </script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
        <meta content="C#" name="CODE_LANGUAGE" />
        <meta content="JavaScript" name="vs_defaultClientScript" />
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
    </head>
    <body>
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" oncontextload="OnContextLoad"></ea:datacontext>
            <ea:datarepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel"
                Width="100%">
                <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
                <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
                <cc1:ReportHeader id="ReportHeader1" title="Magazyn" runat="server"></cc1:ReportHeader>

                <ea:Section id="SectionDokumentHandlowy" runat="server" Width="100%">
                    <em>Dokument handlowy: </em>
                    <ea:DataLabel id="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer" EncodeHTML="True"></ea:DataLabel>
                    <em>&nbsp;z dnia:</em>
                    <ea:DataLabel id="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
                    <br />
                </ea:Section>
                <ea:Section id="SectionMagazyn" runat="server" Width="100%">
                    <em>Magazyn: </em>
                    <ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                    <br />
                </ea:Section>
                <ea:Section id="SectionMagazynDo" runat="server" Width="100%">
                    <em>Z magazynu: </em>
                    <ea:DataLabel id="DataLabel2" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                    <em>Do magazynu: </em>
                    <ea:DataLabel id="DataLabel3" runat="server" DataMember="Dokument.MagazynDo" EncodeHTML="True"></ea:DataLabel>
                    <br />
                </ea:Section>
                <ea:Section id="SectionKontrahent" runat="server" Width="100%">
                    <em>
                        <table id="Table1" cellspacing="0" width="100%">
                            <tr>
                                <td valign="top">
                                        <!-- Oddział firmy -->
                                        <ea:Section ID="OddzialFirmy" runat="server" 
                                            DataMember="Dokument.Wydruk.JestOddzial">
                                        <em style="text-decoration: underline;">Oddział:</em>
                                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative;">
                                        <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Dokument.Wydruk.PieczatkaOddziału.Nazwa" ></ea:DataLabel><br />
                                        <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia1" ></ea:DataLabel><br />
                                        <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia2" ></ea:DataLabel>
                                        </div>
                                        </ea:Section>
                                        <!-- Oddział firmy -->
                                </td>
                                <td valign="top">
                                    <em style="text-decoration: underline;">
                                        <ea:DataLabel id="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>:</em><br />
                                    <div style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                        <ea:DataLabel id="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><br />
                                        <ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
                                        <ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
                                        NIP:
                                        <ea:DataLabel id="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel></div>								
                                    <ea:Section id="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
                                        <em style="text-decoration: underline;">
                                            <ea:DataLabel id="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>:</em>
                                        <div style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                            <ea:DataLabel id="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
                                            NIP:
                                            <ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel></div>
                                    </ea:Section>
                                    <ea:Section id="sectionMiejsceDostawy" runat="server" DataMember="Dokument.Wydruk.JestOdbiorcaMiejsceDostawy">
                                        <em style="text-decoration: underline;">Miejsce dostawy:</em>
                                        <div style="font-size: 13px; left: 10px; font-family: tahoma; position: relative">
                                            <ea:DataLabel id="DataLabel16" runat="server" DataMember="Dokument.OdbiorcaMiejsceDostawy.Nazwa" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel id="DataLabel17" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel id="DataLabel18" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
                                        </div>
                                    </ea:Section>
                                </td>
                            </tr>
                        </table>
                    </em>
                </ea:Section>
                <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                    DataMember="Dokument.Pozycje" >
                    <Columns>
                        <ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp." runat="server"></ea:GridColumn>
                        <ea:GridColumn Width="20" DataMember="Towar.Kod" Caption="Kod towaru" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn Width="20" DataMember="Dostawa.Dokument" Caption="Dok. przyjęcia" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn Width="12" DataMember="ZmianaParametrowZasobuInfo.Ilosc.Value" Caption="Ilość pierwotna" Align="Right" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn Width="12" DataMember="Ilosc.Value" Caption="Ilość po korekcie" Align="Right" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn Width="13" DataMember="ZmianaParametrowZasobuInfo.Wartosc" Caption="Wartość pierwotna" Align="Right" runat="server" EncodeHTML="True"></ea:GridColumn>
                        <ea:GridColumn Width="13" DataMember="Wartość" Caption="Wartość po korekcie" Align="Right" runat="server" EncodeHTML="True" Total="Info"></ea:GridColumn>
                        <ea:GridColumn Width="13" DataMember="ZmianaWartości" Caption="Zmiana wartości" Align="Right" runat="server" EncodeHTML="True" Total="Sum"></ea:GridColumn>
                    </Columns>
                </ea:Grid>
                    <ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
                    <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                        <Subtitles>
                            <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                            <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                        </Subtitles>
                    </cc1:ReportFooter>
                <ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker></ea:datarepeater>
        </form>
    </body>
</html>

